<?php
require_once 'header.php';

if(!$usersObject->ID()) {
	header("Location: /");
	exit;
}

$the_domain = 'http://'.$_SERVER['SERVER_NAME'];

if(isset($_GET['del'])) {
	$id = (int) $db->escape(trim(strip_tags(intval($_GET['del']))));
	$db->query(sprintf("DELETE FROM links WHERE linkID = '%d' AND uID = '%s'", $id, $usersObject->ID()));
	print '<div class="alert alert-error">Removed</div>';
}


$month = date("M");
$year= date("Y");

if(isset($_GET['m'])) $month = (string) $db->escape(trim(strip_tags($_GET['m'])));
if(strlen($month) != 3) die("Incorrect month");

if(isset($_GET['y'])) $year = $db->escape(trim(strip_tags(intval($_GET['y']))));
if(strlen($year) != 4) die("Incorrect year" . $year);

$graph = $db->get_results("SELECT FORMAT(SUM(amount), 5) AS t_day, 
					FROM_UNIXTIME(exact_time, '%Y-%m-%d') AS day FROM 
					publishers WHERE user_ID = '".$usersObject->ID()."' 
					AND month = '$month' AND year = '$year'  
					GROUP BY FROM_UNIXTIME(exact_time, '%Y-%m-%d')");
$total_m = 0.00000;					
?>

<script type="text/javascript">
$(document).ready(function(){
	
  
	
  var line1= [
  	  <?php
	  $line = '';
  	  if($graph) {
	  	  foreach($graph as $G) {
		  	  $line .= '[\''.$G->day.' 4:00PM\', '.number_format($G->t_day, 5).'],';
			  $total_m += number_format($G->t_day, 5);
		  }
	  }else{
	  	for($i=1;$i<=31;$i++) {
	  	  $line .= '[\''.$year.'-'.date("m", strtotime($month)).'-'.$i.' 4:00PM\', '.number_format(0.00000, 5).'],';	
	  	}
	  }
  	  ?>
  	  <?php print rtrim($line, ","); ?>
  ];
      
  var plot1 = $.jqplot('chart1', [line1], {
      
      axes:{
        xaxis:{
          
          renderer:$.jqplot.DateAxisRenderer,
          tickOptions:{
            formatString:'%b&nbsp;%#d'
          },
        },
        yaxis:{
          tickOptions:{
            formatString:'$%.5f'
           },
           min:0
        }
      },
      highlighter: {
        show: true,
        sizeAdjust: 7.5
      },
      cursor: {
        show: false
      }
  });
});	
</script>
<div class="container ctwhite">
	<?php require_once 'announcements.php';?> 
</div>
	
<div class="container ctwhite" style="margin-top:20px;">
	<div class="row">
		<div class="span4">
			<h3 class="headline-inline"><?php print $month . ' ' . $year; ?> <?=translate('report') ?></h3>
			<h4><?=translate('report') ?> : $<?php print number_format($total_m, 5); ?></h4>
		</div>
		<div class="span6" style="text-align: right;">
			<?php
			$months = array('Jan' => 'Jan', 'Feb' => 'Feb',
                                'Mar' => 'Mar', 'Apr' => 'Apr', 
                                'May' => 'May', 'Jun' => 'Jun',
                                'Jul' => 'Jul', 'Aug' => 'Aug',
                                'Sep' => 'Sep', 'Oct' => 'Oct',
                                'Nov' => 'Nov', 'Dec' => 'Dec');
			
			?>
		   <form method="GET" action="" class="form-horizontal">
            <select name="m">
                <?php
                foreach($months as $month_select) {
                    if($month_select == date("M")) {
                        print '<option value="'.$month_select.'" selected="">'.$month_select.'</option>';
                    }else{
                        print '<option value="'.$month_select.'">'.$month_select.'</option>';
                    }
                    print "\n";
                }
                              
                ?>
            </select>
            <select name="y">
                <?php
                for($years = 2012; $years <= date("Y"); $years++) {
                    if($years == date("Y")) {
                        print '<option value="'.$years.'" selected="">'.$years.'</option>';
                    }else{
                        print '<option value="'.$years.'">'.$years.'</option>';
                    } 
                }
                ?>
            </select>
            <input type="submit" name="sbdate" value="Go" class="btn" style="margin-top:5px;"/>
        </form>
		</div>
	</div>
	<div id="chart1" style="height:300px; width:820px;"></div>
</div>	

<div class="container ctwhite" style="margin-top:20px;">

	<h3 class="headline-inline"><?=translate('your_links')?></h3>
	
	<?php
	if(isset($_GET['edit'])) {
	$id = (int) $db->escape(trim(strip_tags(intval($_GET['edit']))));
	$edit_l = $db->get_row("SELECT destination FROM links WHERE linkID = '$id' AND uID = '".$usersObject->ID()."'");
	if(!$edit_l) die("Link not found or not yours"); 
	
	
	if(isset($_POST['sbedit']))	{
		print '<div class="alert alert-warning">';
		$site = $db->escape((string) trim(strip_tags($_POST['site'])));
		
		if(stristr($site, 'http')) {
			$site = str_replace("http://", "", $site);
			$site = str_replace("https://", "", $site);
			$db->query("UPDATE links SET destination = '$site' WHERE linkID = '$id' AND uID = '".$usersObject->ID()."'");
			print 'URL Updated. <a href="publisher.php">Close this.</a>';
		}else{
			print translate('empty_url');
		}
		print '</div>';
	}
	
	?>
	
	<form method="POST" action="" class="form-horizontal">
		<label><?=translate('dest_url') ?>:</label>
		<input type="text" name="site" value="<?php print 'http://'.$edit_l->destination; ?>" class="input-xxlarge"/>
		<br/><br/>
		<input type="submit" name="sbedit" value="<?=translate('update_btn')?>" class="btn btn-warning btn-medium"/>
	</form>
	
	<?php
	}//edit 
	
	$m_start = mktime(0,0,0,date("m", strtotime($month)),1,$year);
	$m_ends = mktime(23,59,59,date("m", strtotime($month)), date('t',strtotime('today')) ,$year);
	
	$user_links = $db->get_results(
					sprintf("SELECT linkID, destination, string, uID, type, 
					    	(SELECT COUNT(*) as views FROM visitors WHERE lstring = string AND time BETWEEN '%s' AND '%s') as views,
					    	(SELECT SUM(amount) as t_amount FROM publishers WHERE link_string = string AND month = '%s' AND year = '%d') as t_amount  
							FROM links WHERE uID = '%d'", $m_start, $m_ends, $month, $year, $db->escape($usersObject->ID())));
	#print $db->last_query;
	?>
	
	<table class="table table-striped table-bordered table-hover" id="pubTable">
		<thead>
			<tr>
				<th><?=translate('website_address')?></th>
				<th><?=translate('type')?></th>
				<th style="cursor: pointer;"><b class="icon-resize-vertical"></b><?=translate('views')?></th>
				<th style="cursor: pointer;"><b class="icon-resize-vertical"></b><?=translate('money_earned')?></th>
				<th><?=translate('actions')?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			if(count($user_links)) {
				foreach($user_links as $l) {
					$l->type = ($l->type == 'inter') ? 'Interstitial' : 'ADS Free';
					$l->t_amount = ($l->t_amount > 0) ? $l->t_amount : '0.00000';
					
					printf('<tr data-ID="%d" class="last-item">', $l->linkID);
					printf('<td><a href="%s" style="font-size:14px;color:#0099FF;">%s</a><br/>', $the_domain.'/'.$l->string, $the_domain.'/'.$l->string);
					printf('<a href="%s" style="font-size:12px;">%s</a></td>', 'http://'.$l->destination, 'http://'.$l->destination);
					printf('<td>%s</td>', $l->type);
					printf('<td>%d</td>', $l->views);
					print '<td>$'.($l->t_amount).'</td>';
					print '<td>
							<a href="publisher.php?edit='.$l->linkID.'"><b class="icon-edit"></b></a>
							<a href="publisher.php?del='.$l->linkID.'" class="confirm" data-lID="'.$l->linkID.'"><b class="icon-remove"></b></a>
						   </td>';
					print '</tr>';
				}	
			}
			?>
		</tbody>
	</table>
		
</div>

<?php
require_once 'footer.php';
?>